/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.tectech.helper.StructureDefinitions;
import com.github.technus.tectech.mechanics.constructable.IConstructable;
import com.github.technus.tectech.mechanics.structure.IStructureDefinition;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.StructureDefinition;
import com.github.technus.tectech.mechanics.structure.StructureUtility;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.google.common.collect.ArrayListMultimap;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class TT_ImplosionCompressor
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private byte blocks = 0;
    private static final byte TEXTURE_INDEX = 16;
    private static final byte SOUND_INDEX = 20;
    private static final ArrayListMultimap<Block, Integer> BLOCKS = ArrayListMultimap.create();
    private static final IStructureDefinition<TT_ImplosionCompressor> STRUCTURE_DEFINITION;

    public TT_ImplosionCompressor(Object unused) {
        super(32765, "multimachine.implosioncompressor", "Implosion Compressor");
        GregTech_API.METATILEENTITIES[32765] = null;
        GregTech_API.METATILEENTITIES[1001] = this;
    }

    private TT_ImplosionCompressor(String aName) {
        super(aName);
    }

    protected boolean cyclicUpdate_EM() {
        return false;
    }

    public final boolean addImplosionHatches(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity != null) {
            IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
            if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch)) {
                return false;
            }
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
                return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
                return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
                return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
                return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
                return this.eEnergyMulti.add((GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
                return this.eDynamoMulti.add((GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
                return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
            }
        }
        return false;
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.blocks = 0;
        return this.structureCheck_EM("main", 1, 1, 0) && this.blocks >= 16;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM("main", 1, 1, 0, b, itemStack);
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return new String[0];
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new TT_ImplosionCompressor(this.mName);
    }

    public String[] getDescription() {
        return new String[]{"Controller Block for the Implosion Compressor", "Size(WxHxD): 3x3x3 (Hollow), Controller (Front centered)", "1x Input Bus (Any casing)", "1x Output Bus (Any casing)", "1x Maintenance Hatch (Any casing)", "1x Muffler Hatch (Any casing)", "1x Energy Hatch (Any casing)", "Solid Steel Machine Casings for the rest (16 at least!)", "Casings can be replaced with Explosion Warning Signs", "Causes " + 20 * this.getPollutionPerTick(null) + " Pollution per second", BW_Tooltip_Reference.ADV_STR_CHECK};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16]};
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "ImplosionCompressor.png");
    }

    public IStructureDefinition<TT_ImplosionCompressor> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        GT_Recipe tRecipe;
        ArrayList tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                if (((ItemStack)tInputList.get((int)i)).field_77994_a >= ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
        if (tInputList.size() > 0 && (tRecipe = GT_Recipe.GT_Recipe_Map.sImplosionRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, tInputs)) != null && tRecipe.isRecipeInputEqual(true, null, tInputs)) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, this.getMaxInputVoltage());
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
            this.sendLoopStart((byte)20);
            this.updateSlots();
            return true;
        }
        return false;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(5)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 500;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    static {
        BLOCKS.put((Object)GregTech_API.sBlockCasings2, (Object)0);
        BLOCKS.put((Object)GregTech_API.sBlockCasings3, (Object)4);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureDefinitions.CUBE_NO_MUFFLER.getDefinition()).addElement(Character.valueOf('V'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofHatchAdder(TT_ImplosionCompressor::addImplosionHatches, (int)16, (int)1), StructureUtility.onElementPass(x -> {
            x.blocks = (byte)(x.blocks + 1);
        }, (IStructureElement)StructureUtility.ofBlocksMap((Map)BLOCKS.asMap(), (Block)GregTech_API.sBlockCasings2, (int)0))})).build();
    }
}

